package ru.yandex.partner.core.filter.db;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;

import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public interface DbFilter<M, V> {

    MetaFilter<? super M, V> getMetaFilter();

    Class<M> getResolvableModelClass();

    Condition getCondition(FilterOperator operator, Collection<V> values);

    default Condition getCondition(FilterOperator operator, V value) {
        return getCondition(operator, List.of(value));
    }

    default void check(FilterOperator operator, Collection<?> values) {
        getMetaFilter().getFilterType().check(operator, values);
    }
}
