package ru.yandex.partner.core.filter.db;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.impl.DSL;

import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public class NoDbFilter<M, V> implements DbFilter<M, V> {
    private final MetaFilter<? super M, V> metaFilter;
    private final Class<M> resolvableModelClass;

    public NoDbFilter(MetaFilter<? super M, V> metaFilter, Class<M> resolvableModelClass) {
        this.metaFilter = metaFilter;
        this.resolvableModelClass = resolvableModelClass;
    }

    @Override
    public MetaFilter<? super M, V> getMetaFilter() {
        return metaFilter;
    }

    @Override
    public Class<M> getResolvableModelClass() {
        return resolvableModelClass;
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<V> values) {
        return DSL.noCondition();
    }
}
