package ru.yandex.partner.core.filter.db;

import java.util.Collection;
import java.util.function.Function;

import org.jooq.Condition;
import org.jooq.Field;

import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

public class NumberDbFilter<M, V extends Number> extends SimpleDbFilter<M, V> {

    public NumberDbFilter(MetaFilter<? super M, V> metaFilter, Class<M> resolvableModelClass, Field<V> tableField) {
        super(metaFilter, resolvableModelClass, tableField);
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<V> values) {
        Function<V, Condition> conditionFunction;
        switch (operator) {
            case GREATER:
                conditionFunction = value -> getField().gt(value);
                break;
            case GREATER_OR_EQUALS:
                conditionFunction = value -> getField().ge(value);
                break;
            case LOWER:
                conditionFunction = value -> getField().lt(value);
                break;
            case LOWER_OR_EQUALS:
                conditionFunction = value -> getField().le(value);
                break;
            default:
                return super.getCondition(operator, values);
        }

        V value = FilterUtils.getSingleValueOrThrow(values, operator);
        return conditionFunction.apply(value);
    }
}
