package ru.yandex.partner.core.filter.db;

import java.util.Collection;
import java.util.function.Function;

import org.jooq.Condition;
import org.jooq.Field;

import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

public class StringDbFilter<M> extends SimpleDbFilter<M, String> {

    public StringDbFilter(MetaFilter<? super M, String> metaFilter, Class<M> resolvableModelClass,
                          Field<String> tableField) {
        super(metaFilter, resolvableModelClass, tableField);
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<String> values) {
        Function<String, Condition> conditionFunction;
        switch (operator) {
            case NOT_LIKE:
                conditionFunction = value -> getField().notLike(likeStr(value));
                break;
            case LIKE:
                conditionFunction = value -> getField().like(likeStr(value));
                break;
            default:
                return super.getCondition(operator, values);
        }
        String value = FilterUtils.getSingleValueOrThrow(values, operator);
        return conditionFunction.apply(value);
    }

    private String likeStr(String value) {
        if (value.isEmpty()) {
            return "%";
        }

        String converted = value
                .replaceAll("%", "\\\\%")
                .replaceAll("_", "\\\\_")
                .replaceAll("\\*", "%")
                .replaceAll("\\?", "_");
        converted = converted.charAt(0) == '^'
                ? converted.substring(1)
                : '%' + converted;
        int lastPos = converted.length() - 1;
        converted = converted.charAt(lastPos) == '$' && converted.charAt(lastPos - 1) != '\\'
                ? converted.substring(0, lastPos)
                : converted + '%';
        return converted;
    }
}
