package ru.yandex.partner.core.filter.db;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.TableField;

import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

public abstract class SubDbFilter<M, SM, V> implements DbFilter<M, V> {
    private final MetaFilter<? super M, V> metaFilter;
    private final MetaFilter<SM, V> subMetaFilter;
    private final Class<M> resolvableModelClass;
    private final TableField<?, Object> filterableField;
    private final TableField<?, Object> selectableField;

    public <F> SubDbFilter(MetaFilter<? super M, V> metaFilter,
                           MetaFilter<SM, V> subMetaFilter,
                           Class<M> resolvableModelClass,
                           TableField<?, F> filterableField, TableField<?, F> selectableField) {
        this.metaFilter = metaFilter;
        this.subMetaFilter = subMetaFilter;
        this.resolvableModelClass = resolvableModelClass;
        this.filterableField = (TableField<?, Object>) filterableField;
        this.selectableField = (TableField<?, Object>) selectableField;
    }

    protected abstract ModelFilterContainer<SM> getModelFilterContainer();

    @Override
    public MetaFilter<? super M, V> getMetaFilter() {
        return metaFilter;
    }

    @Override
    public Class<M> getResolvableModelClass() {
        return resolvableModelClass;
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<V> values) {
        ModelFilterContainer<SM> smModelFilterContainer = getModelFilterContainer();
        DbFilter<SM, V> dbFilter = smModelFilterContainer.getDbFilter(subMetaFilter.getModelClass(), subMetaFilter);

        return FilterUtils.wrapSubCondition(filterableField, selectableField,
                dbFilter.getCondition(operator, values));
    }
}
