package ru.yandex.partner.core.filter.dbmeta;

import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.db.DbFilter;
import ru.yandex.partner.core.filter.meta.MetaFilter;

public abstract class BaseFilter<M, V> extends MetaFilter<M, V> implements DbFilter<M, V> {

    public BaseFilter(String name, FilterType filterType, Class<? super M> modelClass, Class<V> valueClass) {
        super(name, filterType, modelClass, valueClass);
    }

    @Override
    public MetaFilter<? super M, V> getMetaFilter() {
        return this;
    }

    @Override
    public Class<M> getResolvableModelClass() {
        throw new UnsupportedOperationException("Method does not need, because DbFilter is known");
    }
}
