package ru.yandex.partner.core.filter.dbmeta;

import java.util.Collection;
import java.util.stream.Collectors;

import org.jooq.Condition;
import org.jooq.Field;

import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

public class BooleanFilter<M> extends BaseFilter<M, Boolean> {
    private final Field<Long> tableField;

    public BooleanFilter(String name, Class<? super M> modelClass, Field<Long> tableField) {
        super(name, FilterType.BOOLEAN, modelClass, Boolean.class);
        this.tableField = tableField;
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<Boolean> values) {
        return FilterUtils.getConditionInternal(tableField, operator,
                values.stream().map(this::convert).collect(Collectors.toList()));
    }

    private Long convert(Boolean value) {
        return value != null && value
                ? 1L
                : 0L;
    }
}
