package ru.yandex.partner.core.filter.dbmeta

import org.jooq.Condition
import org.jooq.Field
import ru.yandex.partner.core.filter.FilterType
import ru.yandex.partner.core.filter.operator.FilterOperator
import ru.yandex.partner.core.filter.utils.FilterUtils
import java.time.LocalDateTime
import java.util.function.Function

class DateTimeFilter<M>(name: String, modelClass: Class<M>, _field: Field<LocalDateTime>) :
    SimpleFilter<M, LocalDateTime>(name, FilterType.DATE_TIME, modelClass, LocalDateTime::class.java, _field) {

    @Override
    override fun getCondition(operator: FilterOperator, values: Collection<LocalDateTime>): Condition {
        val conditionFunction: Function<LocalDateTime, Condition> = when (operator) {
            FilterOperator.GREATER -> Function<LocalDateTime, Condition> { value: LocalDateTime -> field.gt(value) }
            FilterOperator.GREATER_OR_EQUALS -> Function<LocalDateTime, Condition> { value: LocalDateTime ->
                field.ge(
                    value
                )
            }
            FilterOperator.LOWER -> Function<LocalDateTime, Condition> { value: LocalDateTime -> field.lt(value) }
            FilterOperator.LOWER_OR_EQUALS -> Function<LocalDateTime, Condition> { value: LocalDateTime ->
                field.le(
                    value
                )
            }
            else -> return super.getCondition(operator, values)
        }

        val value = FilterUtils.getSingleValueOrThrow(values, operator)
        return conditionFunction.apply(value)

    }


}
