package ru.yandex.partner.core.filter.dbmeta;

import java.util.Collection;
import java.util.function.Function;

import org.jooq.Condition;
import org.jooq.TableField;

import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

public class NumberFilter<M, V extends Number> extends SimpleFilter<M, V> {

    public NumberFilter(String name, Class<? super M> modelClass, TableField<?, V> tableField) {
        this(name, FilterType.NUMBER, modelClass, tableField);
    }

    public NumberFilter(String name, FilterType filterType, Class<? super M> modelClass, TableField<?, V> tableField) {
        super(name, filterType, modelClass, tableField.getType(), tableField);
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<V> values) {
        Function<V, Condition> conditionFunction;
        switch (operator) {
            case GREATER:
                conditionFunction = value -> getField().gt(value);
                break;
            case GREATER_OR_EQUALS:
                conditionFunction = value -> getField().ge(value);
                break;
            case LOWER:
                conditionFunction = value -> getField().lt(value);
                break;
            case LOWER_OR_EQUALS:
                conditionFunction = value -> getField().le(value);
                break;
            default:
                return super.getCondition(operator, values);
        }

        V value = FilterUtils.getSingleValueOrThrow(values, operator);
        return conditionFunction.apply(value);
    }
}
