package ru.yandex.partner.core.filter.dbmeta;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.TableField;

import ru.yandex.partner.core.entity.PageBlockIds;
import ru.yandex.partner.core.entity.utils.ConditionUtils;
import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public class PageBlockIdFilter<M> extends BaseFilter<M, PageBlockIds> {
    private final TableField<?, Long> pageField;
    private final TableField<?, Long> blockField;

    public PageBlockIdFilter(String name,
                             Class<? super M> modelClass,
                             TableField<?, Long> pageField,
                             TableField<?, Long> blockField) {
        super(name, FilterType.DICTIONARY, modelClass, PageBlockIds.class);
        this.pageField = pageField;
        this.blockField = blockField;
    }


    @Override
    public Condition getCondition(FilterOperator operator, Collection<PageBlockIds> value) {
        return ConditionUtils.toPageBlockCondition(value, pageField, blockField);
    }
}
