package ru.yandex.partner.core.filter.dbmeta;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.Field;

import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

public class SimpleFilter<M, V> extends BaseFilter<M, V> {
    private final Field<V> field;

    public SimpleFilter(String name, FilterType filterType, Class<? super M> modelClass, Class<V> valueClass,
                        Field<V> field) {
        super(name, filterType, modelClass, valueClass);
        this.field = field;
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<V> values) {
        return FilterUtils.getConditionInternal(field, operator, values);
    }

    protected Field<V> getField() {
        return field;
    }
}
