package ru.yandex.partner.core.filter.dbmeta;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.TableField;

import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.DbFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

public abstract class SubFilter<M, SM, V> extends BaseFilter<M, V> {
    private final DbFilter<SM, V> subDbFilter;
    private final TableField<?, Object> filterableField;
    private final TableField<?, Object> selectableField;

    public <F> SubFilter(String name,
                         Class<? super M> modelClass,
                         TableField<?, F> filterableField,
                         TableField<?, F> selectableField,
                         DbFilter<SM, V> subDbFilter) {
        super(name, subDbFilter.getMetaFilter().getFilterType(), modelClass,
                subDbFilter.getMetaFilter().getValueClass());
        this.subDbFilter = subDbFilter;
        this.filterableField = (TableField<?, Object>) filterableField;
        this.selectableField = (TableField<?, Object>) selectableField;
    }

    protected abstract ModelFilterContainer<SM> getModelFilterContainer();

    @Override
    public Condition getCondition(FilterOperator operator, Collection<V> values) {
        return FilterUtils.wrapSubCondition(filterableField, selectableField,
                subDbFilter.getCondition(operator, values));
    }
}
