package ru.yandex.partner.core.filter.dbmeta.models;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;

public class PublicIdFilterModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublicIdFilterModel.class);
    private final SearchType searchType;
    private final long value;

    public PublicIdFilterModel(BlockUniqueIdConverter.Prefixes prefix, String publicId) {

        SearchType tmpSearchType;
        long tmpValue;
        try {
            tmpSearchType = SearchType.BLOCK_ID;
            tmpValue = Long.parseLong(publicId);
        } catch (NumberFormatException e) {
            Long uniqueId = getUniqueId(prefix, publicId);

            if (uniqueId == null) {
                tmpSearchType = SearchType.UNKNOWN;
                tmpValue = -1L;
            } else {
                tmpSearchType = SearchType.UNIQUE_ID;
                tmpValue = uniqueId;
            }
        }

        this.searchType = tmpSearchType;
        this.value = tmpValue;
    }

    public SearchType getSearchType() {
        return searchType;
    }

    public long getValue() {
        return value;
    }

    private Long getUniqueId(BlockUniqueIdConverter.Prefixes prefix, String value) {
        String publicId;
        if (Character.isDigit(value.charAt(0))) {
            publicId = prefix.getPrefixString() + value;
        } else {
            publicId = value;
        }

        try {
            return BlockUniqueIdConverter.convertToUniqueId(publicId);
        } catch (IllegalArgumentException e) {
            LOGGER.debug("Cannot parse public_id. Original value '{}', converted value '{}'", value, publicId, e);
            return null;
        }
    }

    public enum SearchType {
        BLOCK_ID,
        UNIQUE_ID,
        UNKNOWN
    }


}
