package ru.yandex.partner.core.filter.meta;

import java.util.Collection;
import java.util.Objects;

import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.operator.FilterOperator;

public class MetaFilter<M, V> {
    private final String name;
    private final FilterType filterType;
    private final Class<? super M> modelClass;
    private final Class<V> valueClass;

    public MetaFilter(String name, FilterType filterType, Class<? super M> modelClass, Class<V> valueClass) {
        this.name = Objects.requireNonNull(name);
        this.filterType = Objects.requireNonNull(filterType);
        this.modelClass = Objects.requireNonNull(modelClass);
        this.valueClass = Objects.requireNonNull(valueClass);
    }

    public String getName() {
        return name;
    }

    public FilterType getFilterType() {
        return filterType;
    }

    public Class<? super M> getModelClass() {
        return modelClass;
    }

    public Class<V> getValueClass() {
        return valueClass;
    }

    public final <EM extends M> CoreFilterNode<EM> eq(V value) {
        return CoreFilterNode.create(this, FilterOperator.EQUALS, value);
    }

    public final <EM extends M> CoreFilterNode<EM> ne(V value) {
        return CoreFilterNode.create(this, FilterOperator.NOT_EQUALS, value);
    }

    public final <EM extends M> CoreFilterNode<EM> in(Collection<V> values) {
        return CoreFilterNode.create(this, FilterOperator.IN, values);
    }

    public final <EM extends M> CoreFilterNode<EM> notIn(Collection<V> values) {
        return CoreFilterNode.create(this, FilterOperator.NOT_IN, values);
    }

    public final <EM extends M> CoreFilterNode<EM> match(V subFilter) {
        return CoreFilterNode.create(this, FilterOperator.MATCH, subFilter);
    }

    @Override
    public String toString() {
        return "MetaFilter{" +
                "name='" + name + '\'' +
                ", filterType=" + filterType +
                ", modelClass=" + modelClass +
                ", valueClass=" + valueClass +
                '}';
    }
}
