package ru.yandex.partner.core.filter.meta;

import java.util.function.Predicate;

import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.StateFlag;

public class MultistateMetaFilter<M, T extends StateFlag<T>> extends MetaFilter<M, Object> {

    public MultistateMetaFilter(String name, Class<? super M> modelClass) {
        super(name, FilterType.MULTISTATE, modelClass, Object.class);
    }

    public final <EM extends M> CoreFilterNode<EM> eq(Predicate<Multistate<T>> value) {
        return CoreFilterNode.create(this, FilterOperator.EQUALS, value);
    }

    public final <EM extends M> CoreFilterNode<EM> ne(Predicate<Multistate<T>> value) {
        return CoreFilterNode.create(this, FilterOperator.NOT_EQUALS, value);
    }

    public final <EM extends M> CoreFilterNode<EM> match(Predicate<Multistate<T>> subFilter) {
        return CoreFilterNode.create(this, FilterOperator.MATCH, subFilter);
    }

    public MetaFilter<M, Long> asLongFilter() {
        return (MetaFilter) this;
    }

}
