package ru.yandex.partner.core.filter.operator;

import java.util.Objects;
import java.util.function.BiFunction;

import org.jooq.Condition;

public enum BinaryOperator {
    AND(Condition::and),
    OR(Condition::or),
    AND_NOT("AND NOT", Condition::andNot),
    OR_NOT("OR NOT", Condition::orNot);

    private final String label;
    private final BiFunction<Condition, Condition, Condition> biFunction;

    BinaryOperator(java.util.function.BinaryOperator<Condition> biFunction) {
        this.label = name();
        this.biFunction = biFunction;
    }

    BinaryOperator(String label, BiFunction<Condition, Condition, Condition> biFunction) {
        this.label = label;
        this.biFunction = biFunction;
    }

    public Condition doOperation(Condition condition1, Condition condition2) {
        Objects.requireNonNull(condition1);
        Objects.requireNonNull(condition2);
        return biFunction.apply(condition1, condition2);
    }

    public static BinaryOperator valueByLabel(String label) {
        for (BinaryOperator value : values()) {
            if (value.label.equalsIgnoreCase(label)) {
                return value;
            }
        }
        return null;
    }
}
