package ru.yandex.partner.core.filter.operator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FilterOperator {
    EQUALS("=", "=="),
    NOT_EQUALS("<>", "!="),
    IN("IN"),
    NOT_IN("NOT IN"),
    IS("IS"),
    IS_NOT("IS NOT"),
    GREATER(">"),
    GREATER_OR_EQUALS("=>"),
    LOWER("<"),
    LOWER_OR_EQUALS("=<"),
    LIKE("LIKE"),
    NOT_LIKE("NOT LIKE"),
    MATCH("MATCH"),
    NOT_MATCH("NOT MATCH");

    private static final Map<String, FilterOperator> OPERATOR_MAP = createMap();
    private final String mainLabel;
    private final List<String> labels;


    FilterOperator(String mainLabel, String... labels) {
        this.mainLabel = mainLabel;
        this.labels = Stream.of(labels)
                .collect(Collectors.toCollection(ArrayList::new));

        this.labels.add(mainLabel);
    }

    public static FilterOperator valueByLabel(String label) {
        String upperLabel = Objects.requireNonNull(label).toUpperCase();
        return OPERATOR_MAP.get(upperLabel);
    }

    public String getLabel() {
        return mainLabel;
    }

    private static Map<String, FilterOperator> createMap() {
        var map = new HashMap<String, FilterOperator>();
        for (FilterOperator value : values()) {
            for (String label : value.labels) {
                map.put(label.toUpperCase(), value);
            }
        }

        return map;
    }
}
