package ru.yandex.partner.core.filter.operator;

import java.util.function.Function;

import javax.annotation.Nonnull;

import org.jooq.Condition;
import org.jooq.impl.DSL;

public enum UnaryOperator {
    NOT(DSL::not);

    private final Function<Condition, Condition> function;

    UnaryOperator(Function<Condition, Condition> function) {
        this.function = function;
    }

    public Condition doOperation(@Nonnull Condition condition) {
        return function.apply(condition);
    }
}
