package ru.yandex.partner.core.filter.utils;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.TableField;
import org.jooq.impl.DSL;

import ru.yandex.partner.core.filter.operator.FilterOperator;

public class FilterUtils {
    private FilterUtils() {
        // utils
    }

    /**
     * Вспомогательный метод для обобщения ошибок
     */
    public static <V> V getSingleValueOrThrow(Collection<V> values, FilterOperator operator) {
        if (values.size() == 1) {
            return values.iterator().next();
        } else {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            throw new IllegalArgumentException("Too many values. Expected single value. FilterOperator = "
                    .concat(operator.name()).concat(" Class = ")
                    // [0] java.base/java.lang.Thread.getStackTrace(Thread.java)
                    // [1] ru.yandex.partner.core.filter.utils.FilterUtils.getSingleValueOrThrow(FilterUtils.java)
                    // [2] искомый класс фильтра
                    .concat(stackTraceElements[2].getClassName()));
        }
    }

    public static <T> Condition getConditionInternal(Field<T> field, FilterOperator operator, Collection<T> values) {
        return switch (operator) {
            case IN, EQUALS -> values.size() == 1
                    ? field.eq(values.iterator().next())
                    : field.in(values);
            case NOT_IN, NOT_EQUALS -> values.size() == 1
                    ? field.ne(values.iterator().next())
                    : field.notIn(values);
            default -> throw new IllegalArgumentException("Unsupported operator. FilterOperator = "
                    .concat(operator.name()));
        };
    }

    public static <F> Condition wrapSubCondition(Field<F> filterableField, TableField<?, F> selectableField,
                                                 Condition condition) {
        return filterableField.eq(
                DSL.any(
                        DSL.select(selectableField)
                                .from(selectableField.getTable())
                                .where(condition)
                )
        );
    }

    public static <F> Condition wrapSubConditionNegated(Field<F> filterableField, TableField<?, F> selectableField,
                                                        Condition condition) {
        return filterableField.notEqual(
                DSL.all(
                        DSL.select(selectableField)
                                .from(selectableField.getTable())
                                .where(condition)
                )
        );
    }
}
