package ru.yandex.partner.core.i18n.entity.block.type.dspblocks;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum DspBlocksEnum implements GettextMsg {
    _1000x120(msg("1000×120")),
    _160x600(msg("160×600")),
    _240x600(msg("240×600")),
    _240x400(msg("240×400")),
    _300x600(msg("300×600")),
    _300x500(msg("300×500")),
    _300x300(msg("300×300")),
    _300x250(msg("300×250")),
    _320x50(msg("320×50")),
    _320x100(msg("320×100")),
    _336x280(msg("336×280")),
    _728x90(msg("728×90")),
    _970x250(msg("970×250")),
    _970x90(msg("970×90")),
    _100_PERCENT_x250(msg("100%×250")),
    _100_PERCENT_x200(msg("100%×200")),
    _100_PERCENT_x180(msg("100%×180")),
    _100_PERCENT_x120(msg("100%×120")),
    _100_PERCENT_x90(msg("100%×90"));

    private final GettextMsgPayload payload;

    DspBlocksEnum(GettextMsgPayload.Builder payloadBuilder) {
        this.payload = payloadBuilder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm";
    }
}
