package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

/**
 * Please note: in this enum, CONTEXT is being set
 */
public enum BlockActionMsg implements GettextMsg {
    EDIT(msg("Edit")),
    ARCHIVE(msg("Archive")),
    ARCHIVE_WITH_PAGE(msg("Archive with page")),
    ARCHIVE_FROM_ADFOX(msg("Archive from ADFOX"), "lib__Application__Model__Product__VideoBlock.pm"),
    RESTORE(msg("Restore")),
    RESTORE_WITH_PAGE(msg("Restore with page")),
    START(msg("Start")),
    STOP(msg("Stop")),
    SET_CHECK_STATISTICS(msg("Set \"check_statistics\"")),
    RESET_CHECK_STATISTICS(msg("Reset \"check_statistics\"")),
    DUPLICATE(msg("Duplicate")),
    ADD(msg("Add")),
    SET_NEED_UPDATE(msg("Set \"need_update\"")),
    START_UPDATE(msg("Start update")),
    STOP_UPDATE(msg("Stop update"));

    private static final String CONTEXT = "Block action";
    private static final String COMMONT_KEYSET_NAME = "lib__Application__Model__Product__RTB.pm";

    private final GettextMsgPayload payload;
    private final String keyset;

    BlockActionMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder
                .context(CONTEXT)
                .build();
        this.keyset = keyset;
    }

    BlockActionMsg(GettextMsgPayload.Builder builder) {
        this(builder, COMMONT_KEYSET_NAME);
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }

}
