package ru.yandex.partner.core.messages;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum BlockWithDesignTemplatesMsg implements GettextMsg {
    DEFAULT_VIDEO_DESIGN(msg("default video design"));

    private final GettextMsgPayload payload;
    private final String keyset;

    BlockWithDesignTemplatesMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder
                .build();
        this.keyset = keyset;
    }

    BlockWithDesignTemplatesMsg(GettextMsgPayload.Builder builder) {
        this(builder, "lib__Application__Model__Role__Has__Block__DesignTemplates.pm");
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
