package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

/**
 * Please note: in this enum, CONTEXT is being set
 */
public enum CustomBkOptionsActionMsg implements GettextMsg {
    ADD(msg("Add"), "lib__Application__Model__TextTemplate.pm"),
    EDIT(msg("Edit"), "lib__Application__Model__TextTemplate.pm"),
    DELETE(msg("Delete"), "lib__Application__Model__DSP.pm"),
    RESTORE(msg("Restore"), "lib__Application__Model__DSP.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    CustomBkOptionsActionMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
