package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum DesignTemplatesActionMsg implements GettextMsg {
    ADD(msg("Add")),
    EDIT(msg("Edit")),
    ARCHIVE(msg("Archive")),
    RESTORE(msg("Restore"));

    private static final String CONTEXT = "Block action";
    private static final String COMMONT_KEYSET_NAME = "lib__Application__Model__Product__RTB.pm";

    private final GettextMsgPayload payload;
    private final String keyset;

    DesignTemplatesActionMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder
                .context(CONTEXT)
                .build();
        this.keyset = keyset;
    }

    DesignTemplatesActionMsg(GettextMsgPayload.Builder builder) {
        this(builder, COMMONT_KEYSET_NAME);
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }

}
