package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum DspActionMsg implements GettextMsg {
    CREATE_IN_BK(msg("Create dsp in BK")),
    CREATE_IN_PI(msg("Create task in PI")),
    LINK_IN_BALANCE(msg("Link in Balance")),
    START(msg("Turn on the DSP in BS")),
    STOP(msg("Turn off the DSP in BS")),
    REQUEST_FOR_APPROVAL(msg("Request for approval")),
    APPROVE(msg("Approve")),
    EDIT(msg("Edit DSP")),
    START_ON_ALL_PLATFORMS(msg("Turn on the DSP on AdvNet platforms")),
    STOP_ON_ALL_PLATFORMS(msg("Turn off the DSP on Advnet platforms")),
    START_ON_YANDEX_SERVICES(msg("Turn on the DSP on Yandex services")),
    STOP_ON_YANDEX_SERVICES(msg("Turn off the DSP on Yandex services")),
    TEST(msg("Sandbox")),
    ADD(msg("Add new dsp")),
    DELETE(msg("Delete")),
    RESTORE(msg("Restore")),
    SET_FLAG_NEED_CREATE_IN_PI(msg("Set flags need create in PI")),
    SET_FLAG_NOT_NEED_CREATE_IN_PI(msg("Set flags not need create in PI")),
    RESEND_TO_BK(msg("Resend to BS"));

    private static final String COMMONT_KEYSET_NAME = "lib__Application__Model__DSP.pm";

    private final GettextMsgPayload payload;
    private final String keyset;

    DspActionMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.build();
        this.keyset = keyset;
    }

    DspActionMsg(GettextMsgPayload.Builder builder) {
        this(builder, COMMONT_KEYSET_NAME);
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
