package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum ModelTypeMsg implements GettextMsg {
    MOBILE_RTB_BLOCK(msg("Mobile RTB block"));

    private final GettextMsgPayload payload;
    private final String keyset;

    ModelTypeMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
        this.keyset = "lib__Application__Model__Product__AN__MobileApp__RTB.pm";
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
