package ru.yandex.partner.core.messages;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum PageActionMsg implements GettextMsg {
    ADD(msg("Add"), "lib__Application__Model__Page__Site__External.pm"),
    APPROVE(msg("Approve"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    ARCHIVE(msg("Archive")),
    BK_IMPORT_WORKING(msg("Import pages from BK with status working")),
    BK_IMPORT_TESTING(msg("Import pages from BK with status testing")),
    BK_IMPORT_DELETED(msg("Import pages from BK with status deleted")),
    EDIT(msg("Edit")),
    REGISTER_IN_BALANCE(msg("Register in Balance")),
    REJECT(msg("Reject"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    RESET_BLOCKED(msg("Reset blocked"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    RESET_PROTECTED(msg("reset protected"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    RESET_READ_ONLY(msg("Reset read only")),
    RESTORE(msg("Restore")),
    SET_BLOCKED(msg("Set blocked"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    SET_NEED_APPROVE(msg("Set need approve"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    SET_NEED_UPDATE(msg("Set \"need_update\""), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    SET_PROTECTED(msg("Set protected"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    SET_READ_ONLY(msg("Set read only")),
    START(msg("Start")),
    START_TESTING(msg("Start testing")),
    STOP_TESTING(msg("Stop testing")),
    START_UPDATE(msg("Start update"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    STOP(msg("Stop")),
    STOP_UPDATE(msg("Stop update"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    RESTORE_BLOCK_ON_CAMPAIGN(msg("Restore block on campaign")),
    SET_NEED_UPDATE_ON_CAMPAIGN(msg("Set \"need_update\""),
            "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    START_BLOCK_ON_CAMPAIGN(msg("Start block on campaign")),
    REMOVE_MIRROR(msg("Remove mirror")),
    SET_CHECK_STATISTICS(msg("Set \"check_statistics\"")),
    RESET_CHECK_STATISTICS(msg("Reset \"check_statistics\"")),
    CAN_UPDATE_IN_BK(msg("Can update in bk"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    PageActionMsg(GettextMsgPayload.Builder builder) {
        this(builder, "lib__Application__Model__Product__InternalAN__InternalSearchOnSite__Campaign.pm");
    }

    PageActionMsg(GettextMsgPayload.Builder builder, String keyset) {
        this.payload = builder.context("Campaign action").build();
        this.keyset = keyset;
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
