package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum SiteVersionMsg implements GettextMsg {
    // TODO verISon misprint intended, used in both perl and java, must be fixed everywhere
    DESKTOP(msg("Desktop").context("Site verison"), "lib__PiConstants.pm"),
    MOBILE(msg("Mobile"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    TURBO_PAGES(msg("Turbo-pages"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    TURBO_PAGES_DESKTOP(msg("Turbo-pages desktop"), "lib__Application__Model__Role__Has__SiteVersion.pm"),
    MOBILE_FULLSCREEN(msg("Mobile fullscreen"), "lib__PiConstants.pm"),
    MOBILE_REWARDED(msg("Mobile rewarded"), "lib__PiConstants.pm"),
    MOBILE_FLOOR_ADD(msg("Mobile floor_add"), "lib__PiConstants.pm"),
    AMP_PAGES(msg("AMP-pages"), "lib__Application__Model__Product__AN__ContextOnSite__RTB.pm"),
    DESKTOP_OR_MOBILE(msg("Desktop or mobile"), "lib__Application__Model__Role__Has__SiteVersion.pm");

    private final GettextMsgPayload payload;
    private final String keyset;

    SiteVersionMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    SiteVersionMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
