package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum TaskActionMsg implements GettextMsg {
    START(msg("Start")),
    PASS_MILESTONE(msg("Pass milestone")),
    CANCEL(msg("Cancel")),
    FINISH_WITH_SUCCESS(msg("Finish with success")),
    FINISH_WITH_ERROR(msg("Finish with error")),
    RESTART(msg("Restart")),
    NEED_RESTART(msg("Need restart"));

    private static final String KEYSET_NAME = "lib__Application__Model__Queue.pm";

    private final GettextMsgPayload payload;

    TaskActionMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }
}
