package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum TextTemplateMsg implements GettextMsg {
    EDIT(msg("Edit")),
    ADD(msg("Add"));

    private static final String KEYSET_NAME = "lib__Application__Model__TextTemplate.pm";

    private final GettextMsgPayload payload;

    TextTemplateMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }

}
