package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum UserActionMsg implements GettextMsg {
    CREATED_PARTNER_IN_BANNER_STORE(msg("Created partner in BannerStore")),
    PROVIDE_CONTACTS(msg("Provide contacts")),
    UNSUBSCRIBE_FROM_STAT_MONITORING_EMAILS(msg("Unsubscribe from statistics monitoring emails")),
    SET_EXCLUDED_DOMAINS(msg("Set excluded domains")),
    SET_EXCLUDED_PHONES(msg("Set excluded phones")),
    REQUEST_CREATE_IN_BANNER_STORE(msg("Request create partner in BannerStore")),
    SET_USER_ROLE(msg("Adding roles to a user")),
    REVOKE_ROLES(msg("Revoke of the user roles")),
    REQUEST_YAN_CONTRACT(msg("Request YAN contract")),
    YAN_CONTRACT_READY(msg("YAN contract ready")),
    LINK_ADFOX_USER(msg("Link AdFox user")),
    UNLINK_ADFOX_USER(msg("Unlink AdFox user")),
    SET_BLOCKED(msg("Set blocked"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    RESET_BLOCKED(msg("Reset blocked"), "lib__Application__Model__Product__AN__ContextOnSite__Campaign.pm"),
    EDIT_REQUISITES(msg("Edit requisites"));

    private static final String DEFAULT_KEYSET_NAME = "lib__Application__Model__Users.pm";

    private final GettextMsgPayload payload;
    private final String keysetName;

    UserActionMsg(GettextMsgPayload.Builder builder, String keysetName) {
        this.payload = builder.build();
        this.keysetName = keysetName;
    }

    UserActionMsg(GettextMsgPayload.Builder builder) {
        this(builder, DEFAULT_KEYSET_NAME);
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keysetName;
    }

}
