package ru.yandex.partner.core.messages;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum UserTypeMsg implements GettextMsg {
    PARTNER_TUT_BY(msg("Partner TUT.BY")),
    MOBILE_MEDIATOR(msg("Mobile mediator")),
    ADFOX_USER(msg("ADFOX user")),
    VIDEO_BLOGGER(msg("Video blogger")),
    GAMES(msg("Games")),
    EFIR_BLOGGER(msg("Efir blogger"));

    private static final String KEYSET_NAME = "lib__Application__Model__Users.pm";
    private final GettextMsgPayload payload;

    UserTypeMsg(GettextMsgPayload.Builder builder) {
        this.payload = builder.build();
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return KEYSET_NAME;
    }

}
