package ru.yandex.partner.core.multitype.repository;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.multitype.repository.AbstractRepositoryTypeSupport;
import ru.yandex.partner.core.configuration.DslContextProviderStub;

@ParametersAreNonnullByDefault
public abstract class AbstractPartnerRepositoryTypeSupport<T extends Model, A, U>
        extends AbstractRepositoryTypeSupport<T, A, U> implements PartnerRepositoryTypeSupport<T, A, U> {
    private final DSLContext dslContext;

    public AbstractPartnerRepositoryTypeSupport(DSLContext dslContext) {
        super(new DslContextProviderStub(dslContext));
        this.dslContext = dslContext;
    }

    protected DSLContext dslContext() {
        return this.dslContext;
    }
}
