package ru.yandex.partner.core.multitype.repository;

import java.util.Collection;

import org.jooq.Table;
import org.jooq.TableField;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelWithId;

public class CommonTypeSupportModifyStrategy<C extends ModelWithId, R extends org.jooq.Record>
        implements TypeSupportModifyStrategy<C, R> {

    private final Table<R> table;
    private final TableField<R, Long> idTableField;

    public CommonTypeSupportModifyStrategy(Table<R> table, TableField<R, Long> idTableField) {
        this.table = table;
        this.idTableField = idTableField;
    }

    @Override
    public void pushToInsert(JooqMapper<C> jooqMapper,
                             InsertHelperAggregator insertHelperAggregator, C model) {
        insertHelperAggregator.getOrCreate(table).add(jooqMapper, model);
    }

    @Override
    public void processUpdate(JooqMapper<C> jooqMapper,
                              UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<C>> appliedChanges) {
        updateHelperAggregator.getOrCreate(idTableField)
                .processUpdateAll(jooqMapper, appliedChanges);
    }
}
