package ru.yandex.partner.core.multitype.repository;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

import org.jooq.DSLContext;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.repository.RepositoryTypeSupportFacade;
import ru.yandex.direct.multitype.repository.TypeModifyRepository;
import ru.yandex.direct.multitype.repository.TypedRepository;
import ru.yandex.direct.multitype.repository.container.RepositoryContainer;
import ru.yandex.direct.multitype.repository.filter.Filter;
import ru.yandex.partner.core.multitype.repository.relation.Id;

public abstract class PartnerModifyRepository<S extends ModelWithId, T extends S,
        A extends RepositoryContainer, U extends RepositoryContainer>
        extends TypeModifyRepository<S, T, A, U> {
    private final Id<T> modelId;

    public PartnerModifyRepository(
            DslContextProvider ppcDslContextProvider,
            RepositoryTypeSupportFacade<S, ?, A, U> typeSupportFacade,
            TypedRepository<S, ?, A, U> typedRepository,
            Id<T> modelId
    ) {
        super(
                ppcDslContextProvider,
                typeSupportFacade,
                typedRepository
        );
        this.modelId = modelId;
    }

    public void delete(DSLContext dsl, Collection<? extends T> models) {
        Set<Long> idsToDelete = models.stream().map(ModelWithId::getId).collect(Collectors.toSet());

        dsl.deleteQuery(getLockTable())
                .addConditions(modelId.in(idsToDelete));
    }

    @Override
    protected Filter getIdFilter(Collection<Long> modelIds) {
        return modelId.filter(modelIds);
    }
}
