package ru.yandex.partner.core.multitype.repository;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.multitype.repository.RepositoryTypeSupport;
import ru.yandex.partner.core.holder.ModelPropertiesHolder;

/**
 * @param <T> - конечный тип, который обрабатывается репозиторием
 * @param <A> - контейнер, который передается в методы добавления
 * @param <U> - контейнер, который передается в методы обновления
 */
@ParametersAreNonnullByDefault
public interface PartnerRepositoryTypeSupport<T extends Model, A, U> extends RepositoryTypeSupport<T, A, U> {
    /**
     * Возвращает поля таблицы (jooq), соответствующие переданным полям модели.
     */
    Set<Field<?>> getFields(Collection<ModelProperty<?, ?>> modelProperties);

    /**
     * Возвращает множество полей модели, которые затрагиваются при работе этого TypeSupport
     */
    Set<ModelProperty<? super T, ?>> getAffectedModelProperties();

    /**
     * Возвращает множество полей модели, доступных для редактирования
     * Дефолтное поведение - возвращаем пустой ModelPropertiesHolder = ничего нельзя редактировать
     * <p>
     * Правило формирования ModelPropertiesHolder
     * - если поле нельзя редактировать никогда (например ID) - не добавляем его в Holder
     * - если поле нельзя редактировать из-за значений связанных полей - добавляем его в Holder, но ставим флаг = false
     * - также для сложных полей, добавляем в Holder все вложенные ModelProperty, для недоступных для редактирования
     * ставим флаг = false
     */
    default ModelPropertiesHolder getEditableModelProperties(T model) {
        return new ModelPropertiesHolder();
    }
}
