package ru.yandex.partner.core.multitype.repository;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Sets;
import org.jooq.Field;
import org.jooq.Record;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

@ParametersAreNonnullByDefault
public interface PartnerRepositoryTypeSupportWithMapper<T extends Model, A, U>
        extends PartnerRepositoryTypeSupport<T, A, U> {

    /**
     * Если mapper использует writeField, то этот метод лучше переопределить, чтобы возвращать и такие поля
     * тоже - это даст возможность доставать ограничивающие интерфейсы из базы не читая модели полностью.
     * Ещё лучше  научится бы из jooqMapper делать getAllFields() и здесь такой метод заюзать.
     */
    @Override
    default Set<Field<?>> getFields() {
        return getJooqMapper().getFieldsToRead();
    }

    @Override
    default Set<Field<?>> getFields(Collection<ModelProperty<?, ?>> modelProperties) {
        return getJooqMapper().getFieldsToRead(modelProperties);
    }

    @Override
    default <M extends T> void fillFromRecord(M model, Record record) {
        getJooqMapper().fromDb(record, model);
    }

    JooqMapper<T> getJooqMapper();

    @Override
    default Set<ModelProperty<? super T, ?>> getAffectedModelProperties() {
        return Sets.union(getJooqMapper().getReadableModelProperties(), getJooqMapper().getWritableModelProperties());
    }
}
