package ru.yandex.partner.core.multitype.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

@ParametersAreNonnullByDefault
public interface PartnerRepositoryTypeSupportWithoutMapper<T extends Model, A, U>
        extends PartnerRepositoryTypeSupport<T, A, U> {

    @Override
    default Set<Field<?>> getFields() {
        return Collections.emptySet();
    }

    @Override
    default Set<Field<?>> getFields(Collection<ModelProperty<?, ?>> modelProperties) {
        return Collections.emptySet();
    }

    @Override
    default <M extends T> void fillFromRecord(M model, Record record) {
    }
}
