package ru.yandex.partner.core.multitype.repository.relation;

import java.util.List;

import javax.annotation.Nullable;

import com.google.common.collect.MapDifference;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.IncomingFields;

public abstract class BaseRelation<T extends Model, X extends Model, V> implements Relation<T, X, V> {
    private final ModelProperty<? super T, V> containerProperty;
    private final RelationRepository<X> repository;
    private final UpdateStrategy<X> updateStrategy;

    public BaseRelation(
            ModelProperty<? super T, V> containerProperty,
            RelationRepository<X> repository,
            UpdateStrategy<X> updateStrategy
    ) {
        this.containerProperty = containerProperty;
        this.repository = repository;
        this.updateStrategy = updateStrategy;
    }

    @Override
    public void processInsert(List<V> newValues) {
        repository.insert(flattenInsertContainer(newValues));
    }

    protected abstract List<X> flattenInsertContainer(List<V> valuesContainer);

    protected abstract Pair<MapDifference<Long, X>, List<X>> calculateDiff(List<Pair<V, V>> valuesContainer);

    @Override
    public void processUpdate(List<Pair<V, V>> oldAndNewValues, @Nullable IncomingFields updatedFields) {
        updateStrategy.performUpdate(repository, calculateDiff(oldAndNewValues), updatedFields);
    }

    @Override
    public ModelProperty<? super T, V> getProperty() {
        return containerProperty;
    }
}
