package ru.yandex.partner.core.multitype.repository.relation;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class CollectionRelation<T extends Model, X extends Model, V extends Collection<X>>
        extends BaseRelation<T, X, V> {
    private final Function<X, Long> idExtractor;

    public CollectionRelation(
            ModelProperty<? super T, V> collectionProp,
            RelationRepository<X> repository,
            UpdateStrategy<X> updateStrategy,
            Function<X, Long> idExtractor) {
        super(collectionProp, repository, updateStrategy);
        this.idExtractor = idExtractor;
    }

    @Override
    protected List<X> flattenInsertContainer(List<V> valuesContainer) {
        return valuesContainer.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    protected Pair<MapDifference<Long, X>, List<X>> calculateDiff(List<Pair<V, V>> valuesContainer) {
        Map<Boolean, List<X>> toAddOrEdit = StreamEx.of(valuesContainer)
                .map(Pair::getRight)
                .filter(Objects::nonNull)
                .flatMap(Collection::stream)
                .partitioningBy(it -> idExtractor.apply(it) == null);

        var oldItems = valuesContainer.stream()
                .map(Pair::getLeft)
                .filter(Objects::nonNull)
                .flatMap(Collection::stream)
                .collect(Collectors.toMap(
                        idExtractor,
                        Function.identity()
                ));

        var newItems = toAddOrEdit.get(false).stream()
                .collect(Collectors.toMap(
                        idExtractor,
                        Function.identity()
                ));

        return Pair.of(Maps.difference(newItems, oldItems), toAddOrEdit.get(true));
    }
}
