package ru.yandex.partner.core.multitype.repository.relation;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.repository.filter.ConditionFilter;
import ru.yandex.direct.multitype.repository.filter.Filter;

public interface Id<M extends ModelWithId> {
    static <T extends ModelWithId> Id<T> column(TableField<? extends Record, Long> idColumn) {
        return idColumn::in;
    }

    Condition in(Collection<Long> modelIds);

    default Filter filter(Collection<Long> modelIds) {
        return new ConditionFilter() {
            @Override
            protected Condition getCondition() {
                return in(modelIds);
            }

            @Override
            public boolean isEmpty() {
                return modelIds.isEmpty();
            }
        };
    }
}
