package ru.yandex.partner.core.multitype.repository.relation;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class Reference<T extends Model, X extends Model> extends BaseRelation<T, X, X> {
    private final Function<X, Long> idExtractor;

    public Reference(
            ModelProperty<? super T, X> referenceProp,
            RelationRepository<X> repository,
            UpdateStrategy<X> updateStrategy,
            Function<X, Long> idExtractor
    ) {
        super(referenceProp, repository, updateStrategy);
        this.idExtractor = idExtractor;
    }

    @Override
    protected List<X> flattenInsertContainer(List<X> valuesContainer) {
        return valuesContainer;
    }

    @Override
    protected Pair<MapDifference<Long, X>, List<X>> calculateDiff(List<Pair<X, X>> valuesContainer) {
        Map<Boolean, List<X>> toAddOrEdit = StreamEx.of(valuesContainer)
                .map(Pair::getRight)
                .partitioningBy(it -> idExtractor.apply(it) == null);

        var oldItems = valuesContainer.stream().map(Pair::getLeft)
                .collect(Collectors.toMap(
                        idExtractor,
                        Function.identity()
                ));

        var newItems = toAddOrEdit.get(false).stream()
                .collect(Collectors.toMap(
                        idExtractor,
                        Function.identity()
                ));

        return Pair.of(Maps.difference(newItems, oldItems), toAddOrEdit.get(true));
    }
}
