package ru.yandex.partner.core.multitype.repository.relation;

import java.util.List;

import javax.annotation.Nullable;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.IncomingFields;

public interface Relation<T extends Model, X extends Model, V> {

    ModelProperty<? super T, V> getProperty();

    void processUpdate(List<Pair<V, V>> oldAndNewValues, @Nullable IncomingFields updatedFields);

    void processInsert(List<V> newValues);

}
