package ru.yandex.partner.core.multitype.repository.relation;

import java.util.Collection;
import java.util.stream.Collectors;

import org.apache.commons.lang3.tuple.Pair;
import org.jooq.DSLContext;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.Model;
import ru.yandex.partner.core.entity.block.container.IncomingFieldsContainer;
import ru.yandex.partner.core.multitype.repository.AbstractPartnerRepositoryTypeSupport;

public abstract class RelationRepositoryTypeSupport<T extends Model, X extends Model, V, A, U> extends
        AbstractPartnerRepositoryTypeSupport<T, A, U> {

    private final Relation<T, X, V> relation;

    public RelationRepositoryTypeSupport(DSLContext dslContext, Relation<T, X, V> relation) {
        super(dslContext);
        this.relation = relation;
    }

    @Override
    public void updateAdditionTables(DSLContext context,
                                     U updateParameters,
                                     Collection<AppliedChanges<T>> appliedChanges) {
        relation.processUpdate(
                appliedChanges.stream()
                        .map(changes -> Pair.of(
                                changes.getOldValue(relation.getProperty()),
                                changes.getNewValue(relation.getProperty())
                        ))
                        .collect(Collectors.toList()),
                updateParameters instanceof IncomingFieldsContainer
                        ? ((IncomingFieldsContainer) updateParameters).getIncomingFields()
                        : null
        );
    }

    @Override
    public void insertToAdditionTables(DSLContext context,
                                       A addModelParametersContainer,
                                       Collection<T> models) {
        relation.processInsert(
                models.stream().map(relation.getProperty()::get)
                        .collect(Collectors.toList())
        );
    }
}
