package ru.yandex.partner.core.multitype.repository.relation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.Table;
import org.jooq.TableField;

public class SimpleListRelationHelper<R extends Record, X> {
    private final DSLContext dslContext;
    private final Table<R> table;
    private final TableField<R, Long> backReference;
    private final RecordMapper<? super R, X> mapRecord;
    private final BiConsumer<R, X> fillRecord;

    public SimpleListRelationHelper(
            DSLContext dslContext,
            Table<R> table,
            TableField<R, Long> backReference,
            RecordMapper<? super R, X> mapRecord,
            BiConsumer<R, X> fillRecord) {
        this.dslContext = dslContext;
        this.table = table;
        this.backReference = backReference;
        this.mapRecord = mapRecord;
        this.fillRecord = fillRecord;
    }

    public Map<Long, List<X>> groupByIds(Collection<Long> backRefs) {
        if (backRefs == null || backRefs.isEmpty()) {
            return Collections.emptyMap();
        }

        return dslContext.selectFrom(table)
                .where(backReference.in(backRefs))
                .fetchGroups(
                        backReference::get,
                        mapRecord
                );
    }

    public void replaceValues(Map<Long, List<X>> valuesByBackRef) {
        if (valuesByBackRef.isEmpty()) {
            return;
        }

        dslContext.deleteFrom(table)
                .where(backReference.in(valuesByBackRef.keySet()))
                .execute();

        var insert = dslContext.insertQuery(
                table
        );

        valuesByBackRef.forEach((backRefValue, values) -> {
            for (X value : values) {
                var record = table.newRecord();
                fillRecord.accept(record, value);
                record.set(backReference, backRefValue);
                insert.addRecord(record);
            }
        });

        insert.execute();
    }
}
