package ru.yandex.partner.core.multitype.repository.relation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.MapDifference;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.model.Model;
import ru.yandex.partner.core.entity.IncomingFields;

@FunctionalInterface
public
interface UpdateStrategy<X extends Model> {
    static <X extends Model> UpdateStrategy<X> rewrite() {
        return (repository, oldAndNewValues, updatedFields) -> {
            var modelsDiff = oldAndNewValues.getLeft();
            var newChangedEntries =
                    modelsDiff.entriesDiffering().values().stream()
                            .map(MapDifference.ValueDifference::leftValue)
                            .collect(Collectors.toList());
            var oldChangedEntries =
                    modelsDiff.entriesDiffering().values().stream()
                            .map(MapDifference.ValueDifference::rightValue)
                            .collect(Collectors.toList());
            var oldEntries = modelsDiff.entriesOnlyOnRight().values();
            var newEntriesWithSetIds = modelsDiff.entriesOnlyOnLeft().values();

            var toDelete = new ArrayList<X>(oldChangedEntries.size() + oldEntries.size());
            toDelete.addAll(oldChangedEntries);
            toDelete.addAll(oldEntries);

            var toInsert = new ArrayList<X>(
                    newChangedEntries.size() + newEntriesWithSetIds.size()
                            + oldAndNewValues.getRight().size()
            );
            toInsert.addAll(newEntriesWithSetIds);
            toInsert.addAll(newChangedEntries);
            toInsert.addAll(oldAndNewValues.getRight());

            repository.delete(toDelete);
            repository.insert(toInsert);
        };
    }

    void performUpdate(
            RelationRepository<X> repository,
            Pair<MapDifference<Long, X>, List<X>> oldAndNewValues,
            IncomingFields updatedFields
    );
}
