package ru.yandex.partner.core.multitype.service.validation.type;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public abstract class AbstractValidationTypeSupport<T extends ModelWithId, C> implements ValidationTypeSupport<T, C> {

    @Override
    public void fillContainer(C container, List<T> models) {
        // заглушка, не добавляйте сюда логику
    }

    @Override
    public void fillContainerFullDictionaries(C container) {
        // заглушка, не добавляйте сюда логику
    }

    @Override
    public ValidationResult<List<T>, Defect> addPreValidate(C container, ValidationResult<List<T>, Defect> vr) {
        return vr;
    }

    @Override
    public ValidationResult<List<ModelChanges<T>>, Defect> updateValidateModelChanges(
            C container,
            ValidationResult<List<ModelChanges<T>>, Defect> vr) {
        return vr;
    }

    /**
     * Здесь реализуем установку дефолтов, в том числе для optional полей perl, которые в базе NOT NULL
     * perl для таких полей пропускает null/undef значения при валидации и в результате устанавливаются
     * дефолтные значения из настроек базы
     * В Java это поведение должно быть явно реализовано на уровне кода
     * <p>
     * Реализуем в этом методе валидации, так как для некоторых полей необходимо иметь доступ к значениям других полей
     * модели (в методе updateValidateModelChanges этого сделать нельзя)
     *
     * @param container             - контейнер с общими данными
     * @param vr                    - результат валидации ModelChanges к текущему моменту
     * @param unmodifiedValidModels - старые значения моделей
     * @return - результат валидации
     */
    @Override
    public ValidationResult<List<ModelChanges<T>>, Defect> updateValidateBeforeApply(
            C container,
            ValidationResult<List<ModelChanges<T>>, Defect> vr, Map<Long, T> unmodifiedValidModels) {
        return vr;
    }

    @Override
    public ValidationResult<List<T>, Defect> updateValidateAppliedChanges(C container, ValidationResult<List<T>,
            Defect> vr, Map<Integer, AppliedChanges<T>> appliedChangesForValidModelChanges) {
        return vr;
    }

    @Override
    public ValidationResult<List<T>, Defect> validate(C container, ValidationResult<List<T>, Defect> vr) {
        return vr;
    }
}
