package ru.yandex.partner.core.multitype.service.validation.type;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.typesupport.TypeSupport;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public interface ValidationTypeSupport<T extends ModelWithId, C> extends TypeSupport<T> {

    /**
     * Наливает контейнер данными, необходимыми для валидации моделей
     * Метод не должен повторно ходить за данными, если они уже присутствуют в контейнере
     *
     * @param container - контейнер
     * @param models    - список моделей
     */
    void fillContainer(C container, List<T> models);

    /**
     * Полностью заполняет контейнер всеми данными всех справочников
     *
     * @param container - контейнер
     */
    void fillContainerFullDictionaries(C container);

    /**
     * Делает предварительные проверки для моделей
     */
    ValidationResult<List<T>, Defect> addPreValidate(C container, ValidationResult<List<T>, Defect> vr);

    /**
     * Делает проверки ModelChanges, не зависящие от уже сохраненных в базе данных
     */
    ValidationResult<List<ModelChanges<T>>, Defect> updateValidateModelChanges(
            C container,
            ValidationResult<List<ModelChanges<T>>, Defect> vr);

    /**
     * Делает проверки ModelChanges, зависящие от уже сохраненных данных.
     * В unmodifiedValidModels передаются только валидные модели.
     */
    ValidationResult<List<ModelChanges<T>>, Defect> updateValidateBeforeApply(
            C container,
            ValidationResult<List<ModelChanges<T>>, Defect> vr,
            Map<Long, T> unmodifiedValidModels);

    /**
     * Подходит для валидации разрешённых действий - например редактирования.
     * Связанные поля должны устанавливаться после него, дефолты - до него
     */
    ValidationResult<List<T>, Defect> updateValidateAppliedChanges(
            C container,
            ValidationResult<List<T>, Defect> vr,
            Map<Integer, AppliedChanges<T>> appliedChangesForValidModelChanges);

    ValidationResult<List<T>, Defect> validate(C container, ValidationResult<List<T>, Defect> vr);
}
