package ru.yandex.partner.core.operation;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import com.google.common.collect.Streams;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.partner.core.multitype.add.PartnerAddOperationTypeSupport;

public class CoreModelAwareAddOperationTypeSupportFacade
        <T extends ModelWithId, A extends UpdateOperationContainer<T>, B>
        extends PartnerAddOperationTypeSupportFacade<T, A, B> {

    public CoreModelAwareAddOperationTypeSupportFacade(
            List<? extends PartnerAddOperationTypeSupport<? extends T, A, B>> updateOperationTypeSupports,
            List<CoreModelProvider<? extends T>> coreModels
    ) {
        super(
                Streams.concat(
                        updateOperationTypeSupports.stream(),
                        coreModels.stream()
                                .map(CoreModelProvider::getCoreModel)
                                .map(Objects::requireNonNull)
                                .map(DefaultsInitializingAddSupport::new)
                                .map(support -> (PartnerAddOperationTypeSupport<? extends T, A, B>) (Object) support)
                ).collect(Collectors.toList())
        );
    }
}
