package ru.yandex.partner.core.operation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.common.collect.Streams;
import one.util.streamex.StreamEx;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationTypeSupport;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationTypeSupportFacade;
import ru.yandex.direct.multitype.typesupport.TypeSupport;
import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

public class CoreModelAwareUpdateOperationTypeSupportFacade
        <T extends ModelWithId, A extends UpdateOperationContainer<T>, B, C>
        extends UpdateOperationTypeSupportFacade<T, A, B, C> {
    private final List<? extends UpdateOperationTypeSupport<? extends T, A, B, C>> rememberedSupports;
    private final TypeSupportAffectionHelper<T> affectionHelper;

    public CoreModelAwareUpdateOperationTypeSupportFacade(
            List<? extends UpdateOperationTypeSupport<? extends T, A, B, C>> updateOperationTypeSupports,
            List<CoreModelProvider<? extends T>> coreModels,
            PartnerRepositoryTypeSupportFacade<T, ?, ?, ?> repositoryFacade
    ) {
        super(appendSupports(updateOperationTypeSupports, coreModels, repositoryFacade), Set.of());
        this.rememberedSupports = appendSupports(updateOperationTypeSupports, coreModels, repositoryFacade);
        this.affectionHelper = new TypeSupportAffectionHelper<>(Set.of());
    }

    private static <T extends ModelWithId, A extends UpdateOperationContainer<T>, B, C>
    List<UpdateOperationTypeSupport<? extends T, A, B, C>> appendSupports(
            List<? extends UpdateOperationTypeSupport<? extends T, A, B, C>> updateOperationTypeSupports,
            List<CoreModelProvider<? extends T>> coreModels,
            PartnerRepositoryTypeSupportFacade<T, ?, ?, ?> repositoryFacade
    ) {
        return Streams.concat(
                updateOperationTypeSupports.stream(),
                coreModels.stream().map(CoreModelProvider::getCoreModel)
                        .map(Objects::requireNonNull)
                        .map(coreModel -> new DefaultsInitializingUpdateSupport(coreModel, repositoryFacade))
                        .map(support -> (UpdateOperationTypeSupport<? extends T, A, B, C>) support)
        ).collect(Collectors.toList());
    }

    @Override
    public Map<? extends UpdateOperationTypeSupport<? extends T, A, B, C>,
            ? extends List<? extends AppliedChanges<? extends T>>>
    getAppliedChangesGroupedByTypeSupports(
            Collection<? extends AppliedChanges<? extends T>> appliedChanges
    ) {
        return StreamEx.of(this.rememberedSupports)
                .mapToEntry(TypeSupport::getTypeClass)
                .mapValues(supportClass -> affectionHelper.selectAppliedChangesThatAffectSupport(
                        appliedChanges, supportClass))
                .removeValues(List::isEmpty)
                .sorted((entry1, entry2) ->
                        AnnotationAwareOrderComparator.INSTANCE.compare(entry1.getKey(), entry2.getKey()))
                .toCustomMap(LinkedHashMap::new);
    }

}
